#ifndef RESEAU_H_INCLUDED
#define RESEAU_H_INCLUDED

#define BUFFER_MAX 256
#define PORT 4444

#include <stdlib.h>
#include <SDL/SDL_thread.h>
#include <SDL/SDL_net.h>

#include "typedef.h"

typedef enum enum_type_message //Type des messages reus sur le rseau
{
    ERREUR_DECO = 0, //Erreur ou dconnexion
    MESSAGE = 1, //Message "crit" (chat, ...)
    VERSION = 2, //Numro de la version du jeu (Serveur et Client doivent correspondre) et Pseudo de connexion (client -> serveur)
    INFO = 3, //Info sur la partie : nombre de joueurs et numro du joueur (serveur -> client)
    PSEUDO = 4, //Envoie de pseudo (serveur -> client)
    BASE = 5, //Envoie de la position de dpart du joueur (serveur -> client)
    PAQUET_MAP = 6, //Envoie de la map (serveur -> client)
    PAQUET_TILESET = 7, //Envoie du tileset (serveur -> client)
    AJOUTER_PION = 8, //Envoie les donnes d'un pion (serveur -> client)
    EXPLORE = 9, //Envoie d'une ligne de terrain explor (serveur -> client)
    TOUR = 10, //Changement de tour
    PAQUET_DEPLACEMENT = 11, //Dplacement d'un pion
    PTS_MVT = 12, //Envoie des points restants (serveur -> client)
    PAQUET_COMBAT = 13, //Envoie le rsultat d'un combat (serveur -> client)
    MODIF_GRAAL = 14, //Envoie d'une modification du graal (lach(12)/port(8)) (serveur -> client)
    VICTOIRE = 15, //Message de fin de partie (serveur -> client)
    SAUVEGARDE = 16 //Demande de sauvegarde de la partie (client -> serveur)
}type_message;

typedef struct s_paquet //Structure d'un paquet reu du rseau
{
    type_message type; //Type du paquet
    long taille; //Taille des donnes
    char *donnee; //Donnes brutes
    struct s_paquet *suivant; //Pointeur sur le paquet suivant (reu aprs)
}t_paquet;

typedef struct s_serveur //Structure reprsentant le serveur
{
    TCPsocket socket; //Permet de communiquer avec le serveur  travers le rseau
    char dns[BUFFER_MAX]; //Nom DNS du serveur
    IPaddress ip; //Adresse ip du serveur
    long port; //Port utiliser pour communiquer
    t_paquet *paquets; //Contient la liste des paquets reus depuis le serveur et en attente de traitement
    SDL_Thread *thread_id; //Contient un identifiant sur le thread qui s'occupe de la rception des messages
    long connecte; //Vaut 1 si on est connect  un serveur, 0 si on vient de se dconnecter (mmoire  librer) et -1 sinon
}t_serveur;

long res_init(t_serveur *serv); //Initialise le rseau
void res_quit(t_serveur *serv); //Ferme le rseau
long connecter(t_interface *inter, t_serveur *serv, char *host); //Connecte au serveur host au port spcifi dans serv
void deconnecter(t_serveur *serv); //Se dconnecte du serveur
int ecouter_serveur(void *param); //Reoie les messages du serveur
void supprimer_paquets(t_paquet *paquet); //Libre la mmoire alloue  une liste de paquets
long communiquer(type_message type, long taille, char *donnee, t_serveur *serv); //Envoie un paquet au serveur
void envoyer_message(char *mess, t_serveur *serv);

#endif // RESEAU_H_INCLUDED
